/****
 *	CFileMgr.c
 *
 *	Class to manage files in the GWAda application.  This class
 *	is used to keep track of file information in one place.  All other
 *	parts of the system can query a global instance of this class to
 *	get information about file locations.
 *
 *	See header file for more notes.
 *
 ****/

/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include "CFileMgr.h"
#include "CLibrary.h"
//#include "CSourceDoc.h"
#include "SFGetFolder.h"
#include "FileNames.h"

#define DEF_QUANTUM_RSRC  20040


void		CFileMgr::IFileMgr(void)
{
	partName[0] = 0;
	unitName[0] = 0;
}

void	CFileMgr::SetApplicationFolder(FSSpec appl)	// called at startup
{
	application = appl;
}

FSSpec	CFileMgr::GetApplicationFolder(void)
{
	return application;
}

void	CFileMgr::GetApplicationPath(Str255 path)
{
	Str255 temp;

	GetFullPath(application, &temp);
	CopyPString(temp, path);
}

void	CFileMgr::SetCompilerFolder(FSSpec comp)	// called at startup
{
	compiler = comp;
}

FSSpec	CFileMgr::GetCompilerFolder(void)
{
	return compiler;
}

void	CFileMgr::GetCompilerPath(Str255 path)
{
	Str255 temp;

	GetFullPath(compiler, &temp);
	CopyPString(temp, path);
}

void	CFileMgr::SetPart(Str255 name)		// called with each command
{
	CopyPString(name, partName);
}

void	CFileMgr::GetPartName(Str255 name)
{
	CopyPString(partName, name);
}


void	CFileMgr::SetLibraryFolder(FSSpec lib)	// called when lib is opened
{
	library = lib;
}

FSSpec	CFileMgr::GetLibraryFolder(void)
{
	return library;
}

void	CFileMgr::GetLibraryPath(Str255 path)
{
	Str255 temp;

	GetFullPath(library, &temp);
	CopyPString(temp, path);
}

void	CFileMgr::SetSource(FSSpec src)
{
	source = src;
	CopyPString(source.name, unitName);
}

FSSpec	CFileMgr::GetSource(void)
{
	return source;
}

void	CFileMgr::GetSourceName(Str255 name)
{
	CopyPString(unitName, name);
}

void	CFileMgr::GetSourceFolder(Str255 folder)
{
	FSSpec spec;
	Str255 temp;

	FSMakeFSSpec(source.vRefNum, source.parID, "\p:", &spec);
	GetFullPath(spec, &temp);
	CopyPString(temp, folder);
}


void	CFileMgr::SetUnitName(Str255 name)
{
	CopyPString(name, unitName);
}

void	CFileMgr::GetUnitName(Str255 name)
{
	CopyPString(unitName, name);
}


void	CFileMgr::GetOptionsFile(Str255 name)
	// CompFolder:PartName.options
{
Str255 part;

	GetCompilerPath(name);
	GetPartName(part);
	ConcatPStrings(name, part);
	ConcatPStrings(name, "\p.options");
}

void	CFileMgr::GetReturnFile(Str255 name)
	// CompFolder:PartName.return
{
Str255 part;

	GetCompilerPath(name);
	GetPartName(part);
	ConcatPStrings(name, part);
	ConcatPStrings(name, "\p.return");
}

void	CFileMgr::GetQSizeFile(Str255 name)
		// CompFolder:<STR#>
{
Str255 part;

	GetCompilerPath(name);
	GetIndString(part, DEF_QUANTUM_RSRC, 1);
	ConcatPStrings(name, part);
}

void	CFileMgr::GetMsgFile(Str255 name)
	// LibFolder:SourceName.msg
{
	Str255 source, nameOnly;

	GetLibraryPath(name);
	GetSourceName(source);

	ParseFile(source, flName, nameOnly);
	ConcatPStrings(name, nameOnly);
	ConcatPStrings(name, "\p.msg");
}

void	CFileMgr::GetLisFile(Str255 name)
	// UsrFolder:SourceName.lis
{
	Str255 source, nameOnly;

	GetSourceFolder(name);
	GetSourceName(source);

	ParseFile(source, flName, nameOnly);
	ConcatPStrings(name, nameOnly);
	ConcatPStrings(name, "\p.lis");
}

void	CFileMgr::GetErrFile(Str255 name)
	// LibFolder:SourceName.err
{
	Str255 source, nameOnly;

	GetLibraryPath(name);
	GetSourceName(source);

	ParseFile(source, flName, nameOnly);
	ConcatPStrings(name, nameOnly);
	ConcatPStrings(name, "\p.err");
}



// end of file
